 ; Ŀ
 ;   Cdat - update existing blocks from a cdf file.                        
 ;   Copyright 2003 by Rocket Software Ltd.                                
 ;   Based on the earlier program Toob.lsp.                                
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine ASW - remove a sublist from a list.                        
 ;   Arguments: Alist, the list.                                           
 ;              Sub, the sublist to remove.                                
 ;   Returns the modified list.                                            
 ;   Only removes the first matching sublist.                              
 ; 
 (DEFUN ASW (alist sub / subp gnulis)
  (while (setq subp (car alist))
         (setq alist (cdr alist))
         (if (equal sub subp)
             (progn
                  (setq gnulis (append (reverse gnulis) alist))
                  (setq alist ()))
             (setq gnulis (cons subp gnulis))))
 gnulis)
 ; Ŀ
 ;   Subroutine ASW end.                                                   
 ; 

 ; Ŀ
 ;   Subroutine Dread - read a .csv file into a list of lists.             
 ;   Arguments: Fnam, the csv filename.                                    
 ;   Returns a list of lists.                                              
 ; 
 (DEFUN DREAD (fnam / fn linn malist)
  (setq fn (open fnam "r"))
  (while (setq linn (read-line fn))
         (setq linn (csplit linn))
         (setq malist (cons linn malist)))
  (close fn)
 malist)
 ; Ŀ
 ;   Dread end.                                                            
 ; 

 ; Ŀ
 ;   Lisf - write a list of lists back to a csv file.                      
 ;   Arguments: Lisa, the list of sublists.                                
 ;              Filnam, the file name.                                     
 ;   Calls Listos, returns nothing.                                        
 ; 
 (DEFUN LISF (lisa filnam / num sub)
  (setq num 0)
  (if (setq fn (open filnam "w"))
      (progn
           (while (setq sub (nth num dalisa))
                  (write-line (listos sub) fn)
                  (setq num (1+ num)))
           (close fn)))
 (princ))
 ; Ŀ
 ;   Subroutine Lisf end.                                                  
 ; 

 ; Ŀ
 ;   Listos - make a list of strings into a .csv string.                   
 ;   Arguments: Lissa, the list.                                           
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN LISTOS (lissa / num sub astr)
  (setq num 0)
  (while (setq sub (nth num lissa))
         (if astr
             (setq astr (strcat astr "," sub))
             (setq astr sub))
         (setq num (1+ num)))
 astr)
 ; Ŀ
 ;   Subroutine Listos end.                                                
 ; 

 ; Ŀ
 ;   Noovl - update an attribute depending on the value of a string.       
 ;   If the string is ## or "" then empty the attribute, if it is * then   
 ;   don't touch it, otherwise put the string into the attribute.          
 ;   Arguments: Entt, the entity data list for the attribute.              
 ;              Val, an attribute value.                                   
 ;   Returns nothing.                                                      
 ; 
 (DEFUN NOOVL (entt val /)
  (cond ((= val "##")
         (entmod (subst (cons 1 "") (assoc 1 entt) entt)))
        ((and val (/= val "*"))
         (entmod (subst (cons 1 val) (assoc 1 entt) entt))))
 (princ))
 ; Ŀ
 ;   Noovl end.                                                            
 ; 

 ; Ŀ
 ;   Shlist - print the leftover csv data lines.                           
 ;   Arguments: Dalisa, the remaining csv master list.                     
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN SHLIST (dalisa / num sub)
  (setq num 0)
  (while (setq sub (nth num dalisa))
         (print sub)
         (setq num (1+ num)))
 (princ))
 ; Ŀ
 ;   Subroutine Shlist end.                                                
 ; 

 ; Ŀ
 ;   Refill - replace attribute values with new ones from a list.          
 ;   Arguments: Enam, a block insertion ename.                             
 ;              Atlis, a list of new attribute values.                     
 ;   Calls Noovl to update atts depending on the values from the file.     
 ;   Returns zilch.                                                        
 ; 
 (DEFUN REFILL (enam atlis / num entt)
  (setq num 0)
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                       (setq enam (entnext enam)))))))
         (noovl entt (nth num atlis))
         (setq num (1+ num)))
  (entupd enam)
 (princ))
 ; Ŀ
 ;   Refill end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Csplit - divide a text string at commas, make into a list  
 ;   of substrings.                                                        
 ; 
 (DEFUN CSPLIT (linn / len llen pos name1 strlst)
 ; Ŀ
 ;   First knock off leading spaces.  This prevents a string consisting    
 ;   only of spaces from getting into the main loop and crashing.          
 ; 
  (while (and (= (substr linn 1 1) " ")
              (/= (strlen linn) 0))
         (setq linn (substr linn 2)))
 ; Ŀ
 ;   Now process the string.  Note that the space remover is still         
 ;   required for leading spaces in individual fields.                     
 ; 
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) ",")   ; character to split on
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (and (/= 0 (setq llen (strlen name1)))
                     (= (substr name1 llen) " "))
                (setq name1 (substr name1 1 (1- llen))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Csplit end.                                                           
 ; 

 ; Ŀ
 ;   Cdat.                                                                 
 ; 
 (DEFUN C:CDAT (/ filnam dalisa enampt blnam ss enam entt val1 sub prom len)
 ; Ŀ
 ;   Get a cdf file name.                                                  
 ; 
  (cond ((null (setq filnam (getfiled "Data File" "Cdata.csv" "" 12)))
         (prompt "\nData file not found"))
 ; Ŀ
 ;   Read the cdf file into a list of lists.                               
 ; 
        ((null (setq dalisa (dread filnam)))
         (prompt "\nBad Data file"))
 ;      ((null (prompt "Ok to here")))
 ; Ŀ
 ;   Get a block name.                                                     
 ; 
        ((null (and (setq enampt (entsel "Select a block: "))
                    (setq blnam (cdr (assoc 2 (entget (car enampt)))))
                    (null (prompt blnam))))
         (prompt "\nNo Block Selected"))
 ; Ŀ
 ;   Get an ss of blocks to update.                                        
 ; 
        ((null (setq ss (ssget "X" (list (cons 2 blnam)))))
         (prompt "\nNo blocks found"))
 ; Ŀ
 ;   See if each insertion has a matching sublist in Dalisa, if so then    
 ;   update it.                                                            
 ; 
        (T
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (setq entt (entget (entnext enam)))
                  (setq val1 (cdr (assoc 1 entt)))
                  (if (setq sub (assoc val1 dalisa))
                      (progn
                           (refill enam sub)
                           (entupd enam)
                           (setq dalisa (asw dalisa sub)))
                      (prompt "\nNo matching CDF line: " val1)))
 ; Ŀ
 ;   If there was any leftover data (possibly meaning that we need some    
 ;   new block insertions) then mention this, offer to list them, and if   
 ;   so write them to a new csv file.                                      
 ; 
           (if (< 0 (setq len (length dalisa)))
               (progn
                    (setq prom (strcat "\nList " (itoa len)
                                       " leftover data lines <N>: "))
                    (initget 0 "Yes No")
                    (setq insp (getkword prom))
                    (if (= insp "Yes")
                        (progn
                             (textpage)
                             (shlist dalisa)
                             (lisf dalisa "Leftover.csv")
                             (prompt "\n** Extra data lines written to Leftover.csv. **")))))))
 (princ))